'''March 27th 2019
Script to preprocess raw data.
The option make_processed_files takes the downloaded files and
accumulates spikes, angles and state information into a single
Python friendly structure.
The option make_rates takes the file generated by make_processed_files
and computes rate estimates from the spike timings.
'''

from __future__ import division
import numpy as np
import numpy.linalg as la
import sys, os 
import time, datetime

gen_fn_dir = os.path.abspath('..') + '/shared_scripts'
sys.path.append(gen_fn_dir)

import general_file_fns as gff
import data_read_fns as drf
import rate_functions as rf

# Paths to save the data are in this dict. If you haven't already, edit
# general_params/make_general_params_file.py to set the paths you want
# and run it to generate general_params.p
gen_params = gff.load_pickle_file('../general_params/general_params.p')

session = 'Mouse28-140313'

make_processed_files = True
make_rates = True

if make_processed_files:
    data_path = gen_params['raw_data_dir'] + session + '/'
    params = {'session': 'Mouse28-140313', 'data_path': data_path,
              'eeg_sampling_rate': 1250., 'spike_sampling_interval': 1.0 / (20e3)}
    data = drf.gather_session_spike_info(params)
    save_dir = gff.return_dir(gen_params['processed_data_dir'])
    gff.save_pickle_file(data, save_dir + '%s.p'%session)

if make_rates:
    print 'Getting kernel rates'
    t0 = time.time()
    sigma = 0.1
    params = {'dt' : 0.05, 'method' : 'gaussian', 'sigma' : sigma}
    inp_data = gff.load_pickle_file(gen_params['processed_data_dir'] + 
        '%s.p'%session)
    rates = rf.get_rates_and_angles_by_interval(inp_data, params, smooth_type='kernel',
        just_wake=True)
    save_dir = gff.return_dir(gen_params['kernel_rates_dir'] + '%0.0fms_sigma/'%(sigma*1000))
    gff.save_pickle_file(rates, save_dir + '%s.p'%session)
    print 'Time ', time.time() - t0

